/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.Embers;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.event.DialInformationEvent;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.misc.IMetalCoefficient;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberActivationFX;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityBoilerTop;
import teamroots.embers.util.Misc;

public class TileEntityBoilerBottom
extends TileFluidHandler
implements ITileEntityBase,
ITickable,
IExtraDialInformation,
IExtraCapabilityInformation {
    public static final float BASE_MULTIPLIER = 1.5f;
    public static final int FLUID_CONSUMED = 25;
    public static final float PER_BLOCK_MULTIPLIER = 0.375f;
    public static final int PROCESS_TIME = 20;
    public static int capacity = 8000;
    Random random = new Random();
    int progress = -1;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityBoilerBottom.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (EmbersAPI.getEmberValue(stack) == 0.0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    private List<IUpgradeProvider> upgrades = new ArrayList<IUpgradeProvider>();

    public TileEntityBoilerBottom() {
        this.tank = new FluidTank(capacity);
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() instanceof ItemBucket || heldItem.func_77973_b() instanceof UniversalBucket) {
            boolean didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank);
            this.func_70296_d();
            return didFill;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(this.func_145831_w(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public double getMultiplier() {
        IBlockState metalState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        IMetalCoefficient metalCoefficient = EmbersAPI.getMetalCoefficient(metalState);
        double metalMultiplier = metalCoefficient != null ? metalCoefficient.getCoefficient(metalState) : 0.0;
        double totalMult = 1.5;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b().func_177972_a(facing));
            if (state.func_177230_c() != Blocks.field_150353_l && state.func_177230_c() != Blocks.field_150356_k && state.func_177230_c() != Blocks.field_150480_ab) continue;
            totalMult += 0.375 * metalMultiplier;
        }
        return totalMult;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        boolean cancel;
        this.upgrades = UpgradeUtil.getUpgrades(this.field_145850_b, this.field_174879_c, EnumFacing.field_176754_o);
        UpgradeUtil.verifyUpgrades((TileEntity)this, this.upgrades);
        if (UpgradeUtil.doTick((TileEntity)this, this.upgrades)) {
            return;
        }
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177984_a());
        int i = this.random.nextInt(this.inventory.getSlots());
        ItemStack emberStack = this.inventory.getStackInSlot(i);
        if (this.tank.getFluid() != null && this.tank.getFluid().getFluid() == FluidRegistry.WATER && this.tank.getFluidAmount() >= 25 && !emberStack.func_190926_b() && !(cancel = UpgradeUtil.doWork((TileEntity)this, this.upgrades)) && tile instanceof TileEntityBoilerTop) {
            TileEntityBoilerTop top = (TileEntityBoilerTop)tile;
            ++this.progress;
            if (this.progress > UpgradeUtil.getWorkTime((TileEntity)this, 20, this.upgrades)) {
                this.progress = 0;
                double emberValue = EmbersAPI.getEmberValue(emberStack);
                double ember = UpgradeUtil.getTotalEmberProduction((TileEntity)this, emberValue * this.getMultiplier(), this.upgrades);
                if (ember > 0.0 && top.capability.getEmber() + ember <= top.capability.getEmberCapacity()) {
                    if (!this.field_145850_b.field_72995_K) {
                        this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundManager.PRESSURE_REFINERY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberActivationFX((float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 1.5f, (float)this.func_174877_v().func_177952_p() + 0.5f));
                    }
                    UpgradeUtil.throwEvent((TileEntity)this, new EmberEvent((TileEntity)this, EmberEvent.EnumType.PRODUCE, ember), this.upgrades);
                    top.capability.addAmount(ember, true);
                    this.inventory.extractItem(i, 1, false);
                    this.tank.drain(25, true);
                    this.func_70296_d();
                    top.func_70296_d();
                }
            }
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE((TileEntity)this);
    }

    @Override
    public void addDialInformation(EnumFacing facing, List<String> information, String dialType) {
        if ("ember".equals(dialType)) {
            DecimalFormat multiplierFormat = Embers.proxy.getDecimalFormat("embers.decimal_format.ember_multiplier");
            double multiplier = this.getMultiplier();
            information.add(I18n.func_135052_a((String)"embers.tooltip.dial.ember_multiplier", (Object[])new Object[]{multiplierFormat.format(multiplier)}));
        }
        UpgradeUtil.throwEvent((TileEntity)this, new DialInformationEvent((TileEntity)this, information, dialType), this.upgrades);
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.item", I18n.func_135052_a((String)"embers.tooltip.goggles.item.ember", (Object[])new Object[0])));
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            strings.add(IExtraCapabilityInformation.formatCapability(IExtraCapabilityInformation.EnumIOType.INPUT, "embers.tooltip.goggles.fluid", I18n.func_135052_a((String)"embers.tooltip.goggles.fluid.water", (Object[])new Object[0])));
        }
    }
}

