/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.recipe;

import java.awt.Color;
import net.minecraftforge.fluids.FluidStack;
import teamroots.embers.util.FluidUtil;

public class FluidReactionRecipe {
    public FluidStack input;
    public FluidStack output;
    public Color color;

    public FluidReactionRecipe(FluidStack input, FluidStack output, Color color) {
        this.input = input;
        this.output = output;
        this.color = color;
    }

    public boolean matches(FluidStack test) {
        return test != null && FluidUtil.areFluidsEqual(test.getFluid(), this.input.getFluid()) && test.amount >= this.input.amount;
    }

    public int getTimes(FluidStack input, FluidStack output) {
        return Math.min(input.amount / this.input.amount, output.amount / this.output.amount);
    }

    public FluidStack getResult(FluidStack input) {
        FluidStack copy = this.output.copy();
        copy.amount *= input.amount;
        return copy;
    }

    public Color getColor() {
        return this.color;
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }
}

