/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.network.message;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import teamroots.embers.research.ResearchManager;

public class MessageResearchData
implements IMessage {
    public static final int NAME_MAX_LENGTH = 64;
    Map<String, Boolean> ticks;

    public MessageResearchData() {
        this.ticks = new HashMap<String, Boolean>();
    }

    public MessageResearchData(Map<String, Boolean> ticks) {
        this.ticks = ticks;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        int entries = buffer.readInt();
        for (int i = 0; i < entries; ++i) {
            String key = buffer.func_150789_c(64);
            boolean value = buffer.readBoolean();
            this.ticks.put(key, value);
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.writeInt(this.ticks.size());
        for (Map.Entry<String, Boolean> entry : this.ticks.entrySet()) {
            buffer.func_180714_a(entry.getKey());
            buffer.writeBoolean(entry.getValue().booleanValue());
        }
    }

    public static class MessageHolder
    implements IMessageHandler<MessageResearchData, IMessage> {
        public IMessage onMessage(MessageResearchData message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> ResearchManager.receiveResearchData(message.ticks));
            return null;
        }
    }
}

