/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.util.EmberInventoryUtil;
import teamroots.embers.util.Misc;

public class ModifierBlastingCore
extends ModifierBase {
    private HashSet<Entity> blastedEntities = new HashSet();

    public ModifierBlastingCore() {
        super(ModifierBase.EnumType.TOOL_OR_ARMOR, "blasting_core", 2.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private double getChanceBonus(double resonance) {
        if (resonance > 1.0) {
            return 1.0 + (resonance - 1.0) * 0.5;
        }
        return resonance;
    }

    @SubscribeEvent
    public void onDrops(BlockEvent.BreakEvent event) {
        ItemStack s;
        int blastingLevel;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (event.getPlayer() != null && !event.getPlayer().func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && (blastingLevel = ItemModUtil.getModifierLevel(s = event.getPlayer().func_184586_b(EnumHand.MAIN_HAND), EmbersAPI.BLASTING_CORE)) > 0 && EmberInventoryUtil.getEmberTotal(event.getPlayer()) >= this.cost) {
            world.func_72876_a((Entity)event.getPlayer(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.5f, true);
            double resonance = EmbersAPI.getEmberEfficiency(s);
            double chance = (double)blastingLevel / (double)(blastingLevel + 1) * this.getChanceBonus(resonance);
            for (BlockPos toExplode : this.getBlastCube(world, pos, event.getPlayer(), chance)) {
                IBlockState state = world.func_180495_p(toExplode);
                if (!(state.func_185887_b(world, toExplode) >= 0.0f) || !event.getPlayer().func_184823_b(world.func_180495_p(toExplode))) continue;
                world.func_175655_b(toExplode, true);
                world.func_184138_a(toExplode, state, Blocks.field_150350_a.func_176223_P(), 8);
            }
            EmberInventoryUtil.removeEmber(event.getPlayer(), this.cost);
        }
    }

    public Iterable<BlockPos> getBlastAdjacent(World world, BlockPos pos, EntityPlayer player, double chance) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int i = 0; i < 6; ++i) {
            EnumFacing face = EnumFacing.func_82600_a((int)i);
            if (!(Misc.random.nextDouble() < chance)) continue;
            posList.add(pos.func_177972_a(face));
        }
        return posList;
    }

    public Iterable<BlockPos> getBlastCube(World world, BlockPos pos, EntityPlayer player, double chance) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (EnumFacing facePrimary : EnumFacing.field_82609_l) {
            if (!(Misc.random.nextDouble() < chance)) continue;
            BlockPos posPrimary = pos.func_177972_a(facePrimary);
            posList.add(posPrimary);
            for (EnumFacing faceSecondary : EnumFacing.field_82609_l) {
                if (faceSecondary.func_176740_k() == facePrimary.func_176740_k() || !(Misc.random.nextDouble() < chance - 0.5)) continue;
                BlockPos posSecondary = posPrimary.func_177972_a(faceSecondary);
                posList.add(posSecondary);
                for (EnumFacing faceTertiary : EnumFacing.field_82609_l) {
                    if (faceTertiary.func_176740_k() == facePrimary.func_176740_k() || faceTertiary.func_176740_k() == faceSecondary.func_176740_k() || !(Misc.random.nextDouble() < chance - 1.0)) continue;
                    BlockPos posTertiary = posSecondary.func_177972_a(faceTertiary);
                    posList.add(posTertiary);
                }
            }
        }
        return posList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onHit(LivingHurtEvent event) {
        if (!this.blastedEntities.contains(event.getEntity())) {
            try {
                int blastingLevel;
                EntityPlayer damager;
                if (event.getSource().func_76346_g() instanceof EntityPlayer) {
                    int blastingLevel2;
                    damager = (EntityPlayer)event.getSource().func_76346_g();
                    this.blastedEntities.add((Entity)damager);
                    ItemStack s = damager.func_184614_ca();
                    if (!s.func_190926_b() && (blastingLevel2 = ItemModUtil.getModifierLevel(s, EmbersAPI.BLASTING_CORE)) > 0 && EmberInventoryUtil.getEmberTotal(damager) >= this.cost) {
                        double resonance = EmbersAPI.getEmberEfficiency(s);
                        float strength = (float)((resonance + 1.0) * (Math.atan(0.6 * (double)blastingLevel2) / Math.PI));
                        EmberInventoryUtil.removeEmber(damager, this.cost);
                        List entities = damager.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(event.getEntityLiving().field_70165_t - 4.0 * (double)strength, event.getEntityLiving().field_70163_u - 4.0 * (double)strength, event.getEntityLiving().field_70161_v - 4.0 * (double)strength, event.getEntityLiving().field_70165_t + 4.0 * (double)strength, event.getEntityLiving().field_70163_u + 4.0 * (double)strength, event.getEntityLiving().field_70161_v + 4.0 * (double)strength));
                        for (EntityLivingBase e : entities) {
                            if (Objects.equals(e.func_110124_au(), damager.func_110124_au())) continue;
                            e.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)damager), event.getAmount() * strength);
                            e.field_70172_ad = 0;
                        }
                        event.getEntityLiving().field_70170_p.func_72876_a((Entity)event.getEntityLiving(), event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u + (double)event.getEntityLiving().field_70131_O / 2.0, event.getEntityLiving().field_70161_v, 0.5f, true);
                    }
                }
                if (event.getEntity() instanceof EntityPlayer && (blastingLevel = ItemModUtil.getArmorModifierLevel((EntityLivingBase)(damager = (EntityPlayer)event.getEntity()), EmbersAPI.BLASTING_CORE)) > 0 && EmberInventoryUtil.getEmberTotal(damager) >= this.cost) {
                    float strength = (float)(2.0 * (Math.atan(0.6 * (double)blastingLevel) / Math.PI));
                    EmberInventoryUtil.removeEmber(damager, this.cost);
                    List entities = damager.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(event.getEntityLiving().field_70165_t - 4.0 * (double)strength, event.getEntityLiving().field_70163_u - 4.0 * (double)strength, event.getEntityLiving().field_70161_v - 4.0 * (double)strength, event.getEntityLiving().field_70165_t + 4.0 * (double)strength, event.getEntityLiving().field_70163_u + 4.0 * (double)strength, event.getEntityLiving().field_70161_v + 4.0 * (double)strength));
                    for (EntityLivingBase e : entities) {
                        if (Objects.equals(e.func_110124_au(), event.getEntity().func_110124_au())) continue;
                        this.blastedEntities.add((Entity)e);
                        e.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)damager), event.getAmount() * strength * 0.25f);
                        e.func_70653_a(event.getEntity(), 2.0f * strength, -e.field_70165_t + damager.field_70165_t, -e.field_70161_v + damager.field_70161_v);
                        e.field_70172_ad = 0;
                    }
                    event.getEntityLiving().field_70170_p.func_72876_a((Entity)event.getEntityLiving(), event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u + (double)event.getEntityLiving().field_70131_O / 2.0, event.getEntityLiving().field_70161_v, 0.5f, true);
                }
            }
            finally {
                this.blastedEntities.clear();
            }
        }
    }
}

