/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberBurstFX;
import teamroots.embers.network.message.MessageFireBlastFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.Misc;

public class EntityMagmaProjectile
extends Entity {
    private final Predicate<Entity> VALID_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(Entity entity) {
            return entity.func_70067_L() && entity != EntityMagmaProjectile.this.owner;
        }
    }});
    public static final DataParameter<Integer> typeOrdinal = EntityDataManager.func_187226_a(EntityMagmaProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> explosionTimer = EntityDataManager.func_187226_a(EntityMagmaProjectile.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> pillarHeight = EntityDataManager.func_187226_a(EntityMagmaProjectile.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Integer> tick = EntityDataManager.func_187226_a(EntityMagmaProjectile.class, (DataSerializer)DataSerializers.field_187192_b);
    EntityMagmaWorm owner;
    Supplier<Vec3d> homingTarget;
    double homingRatio = 0.1;
    double homingVelocity = 0.3;
    Predicate<Entity> entityTarget = this.VALID_TARGETS;
    boolean pierceBlocks = false;
    double gravity;
    double maxGravity;

    public EntityMagmaProjectile(World worldIn) {
        super(worldIn);
    }

    public EntityMagmaProjectile(World worldIn, EntityMagmaWorm owner) {
        super(worldIn);
        this.owner = owner;
    }

    public void makeMortar(Vec3d velocity) {
        this.setType(Type.MORTAR);
        this.field_70159_w = velocity.field_72450_a;
        this.field_70181_x = velocity.field_72448_b;
        this.field_70179_y = velocity.field_72449_c;
        this.gravity = 0.007;
        this.maxGravity = this.field_70146_Z.nextDouble() * 0.2 + 0.1;
        this.setExplosionTimer(1.0f);
        this.entityTarget = Predicates.alwaysFalse();
    }

    public void makePillar(float height, int delay) {
        this.setType(Type.PILLAR);
        this.setExplosionTimer(1.0f);
        this.entityTarget = Predicates.alwaysFalse();
        this.pierceBlocks = true;
        this.setPillarHeight(height);
        this.setTick(-delay);
    }

    public void makeHoming(Vec3d velocity, Entity target) {
        this.setType(Type.HOMING);
        this.field_70159_w = velocity.field_72450_a;
        this.field_70181_x = velocity.field_72448_b;
        this.field_70179_y = velocity.field_72449_c;
        this.homingRatio = 0.0;
        this.homingVelocity = 0.6;
        this.homingTarget = () -> new Vec3d(target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
    }

    public void makeSplash(Vec3d velocity) {
        this.setType(Type.SPLASH);
        this.field_70159_w = velocity.field_72450_a;
        this.field_70181_x = velocity.field_72448_b;
        this.field_70179_y = velocity.field_72449_c;
        this.gravity = 0.007;
        this.maxGravity = 0.5;
        this.pierceBlocks = true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int tick = this.getTick();
        float explosionTimer = this.getExplosionTimer();
        switch (this.getType()) {
            case GUN: {
                break;
            }
            case MORTAR: {
                if (!this.field_70170_p.field_72995_K) {
                    double height = this.field_70170_p.func_175645_m(this.func_180425_c()).func_177956_o();
                    if (this.field_70163_u < height + 1.5) {
                        this.field_70181_x = Math.max(this.field_70181_x, 0.0) + 0.04;
                    }
                    if (tick > 100) {
                        this.field_70159_w *= 0.9;
                        this.field_70179_y *= 0.9;
                    }
                    if (this.field_70163_u < height + 3.0 && this.field_70181_x > 0.0 || explosionTimer < 1.0f) {
                        this.setExplosionTimer(explosionTimer - 0.05f);
                    }
                    if (!(explosionTimer <= 0.0f)) break;
                    this.func_70106_y();
                    PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageFireBlastFX(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v, new Color(255, 64, 16), 5.0f, 15), (Entity)this);
                    break;
                }
                if (!(explosionTimer > 0.0f) || !(explosionTimer < 1.0f)) break;
                this.showTimer(explosionTimer, 12, 30, new Color(255, 64, 16), 3.0, 1.0f);
                break;
            }
            case PILLAR: {
                float chargeTimer = 1.0f - (float)tick / 40.0f;
                float pillarTimer = ((float)tick - 40.0f) / 40.0f;
                if (!this.field_70170_p.field_72995_K) {
                    if (!(pillarTimer > 1.0f)) break;
                    this.func_70106_y();
                    break;
                }
                if (chargeTimer > 0.0f && chargeTimer < 1.0f) {
                    this.showTimer(chargeTimer, 50, 10, new Color(255, 64, 16), 3.0, 0.0f);
                    break;
                }
                if (!(pillarTimer > 0.0f) || !(pillarTimer < 1.0f)) break;
                double height = Math.sin((double)MathHelper.func_76131_a((float)pillarTimer, (float)0.0f, (float)1.0f) * Math.PI) * (double)this.getPillarHeight();
                Color particleColor = new Color(255, 64, 16);
                int i = 0;
                while ((double)i < height) {
                    for (int e = 0; e < 5; ++e) {
                        double width = Math.cos((double)MathHelper.func_76131_a((float)pillarTimer, (float)0.0f, (float)1.0f) * Math.PI * 0.5) * 6.0;
                        int lifetime = this.field_70146_Z.nextInt(20) + 20;
                        double angle = this.field_70146_Z.nextDouble() * Math.PI * 2.0;
                        double dx = Math.sin(angle) * width / (double)lifetime;
                        double dy = (0.5 + this.field_70146_Z.nextDouble() * 1.0) / (double)lifetime;
                        double dz = Math.cos(angle) * width / (double)lifetime;
                        ParticleUtil.spawnParticleGlow(this.field_70170_p, (float)this.field_70165_t, (float)(this.field_70163_u + this.field_70146_Z.nextDouble() * height), (float)this.field_70161_v, (float)dx, (float)dy, (float)dz, particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), (float)(width * 3.0), lifetime);
                    }
                    ++i;
                }
                break;
            }
            case HOMING: {
                if (tick > 250) {
                    this.func_70106_y();
                    break;
                }
                if (tick > 150 || this.homingTarget != null && this.func_174791_d().func_72436_e((Vec3d)this.homingTarget.get()) < 25.0) {
                    this.homingTarget = null;
                    break;
                }
                if (tick <= 20) break;
                this.homingRatio += 0.001;
                break;
            }
            case SPLASH: {
                this.field_70159_w *= 0.98;
                this.field_70179_y *= 0.98;
                if (tick <= 100) break;
                this.func_70106_y();
                break;
            }
            case TURRET: {
                break;
            }
            case TURRET_FLOAT: {
                break;
            }
        }
        this.updateMove();
        this.setTick(tick + 1);
    }

    public void showTimer(float timer, int segments, int lifetime, Color color, double size, float variance) {
        Random random = new Random(this.func_145782_y());
        int tick = this.getTick();
        float segmentSize = 360.0f / (float)segments;
        float angleOffset = tick * 5;
        float pitchVariance = 20.0f * variance;
        for (int i = 0; i < segments; ++i) {
            float yaw = (float)i / (float)segments * 360.0f + angleOffset;
            Vec3d offset = Vec3d.func_189986_a((float)(random.nextFloat() * pitchVariance - pitchVariance / 2.0f), (float)(yaw + random.nextFloat() * segmentSize * variance * 0.5f)).func_186678_a(size * (double)timer);
            ParticleUtil.spawnParticleGlow(this.field_70170_p, (float)(this.field_70165_t + offset.field_72450_a), (float)(this.field_70163_u + offset.field_72448_b), (float)(this.field_70161_v + offset.field_72449_c), 0.0f, 0.0f, 0.0f, color.getRed(), color.getGreen(), color.getBlue(), 3.0f, lifetime);
        }
    }

    public void updateMove() {
        RayTraceResult hitEntity;
        Vec3d newPosVector;
        Vec3d currPosVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d hitVec = newPosVector = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(currPosVec, newPosVector, false, true, false);
        if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS && !this.canPierce(raytraceresult)) {
            hitVec = raytraceresult.field_72307_f;
        }
        if ((hitEntity = Misc.findEntityOnPath(this.field_70170_p, this, (Entity)this.owner, this.func_174813_aQ(), currPosVec, hitVec, this.entityTarget)) != null) {
            if (!this.canPierce(hitEntity)) {
                hitVec = hitEntity.field_72307_f;
            }
            raytraceresult = hitEntity;
        }
        if (-this.field_70181_x < this.maxGravity) {
            this.field_70181_x -= this.gravity;
        }
        if (!this.field_70170_p.field_72995_K && raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.onHit(raytraceresult);
        }
        newPosVector = hitVec;
        this.field_70165_t = newPosVector.field_72450_a;
        this.field_70163_u = newPosVector.field_72448_b;
        this.field_70161_v = newPosVector.field_72449_c;
        this.handleHoming();
        this.handleTrail();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void handleTrail() {
        if (this.field_70170_p.field_72995_K) {
            Color particleColor = new Color(255, 64, 16);
            double deltaX = this.field_70165_t - this.field_70169_q;
            double deltaY = this.field_70163_u - this.field_70167_r;
            double deltaZ = this.field_70161_v - this.field_70166_s;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 10.0);
            block8: for (double i = 0.0; i < dist; i += 1.0) {
                double coeff = i / dist;
                float px = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * coeff);
                float py = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * coeff);
                float pz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * coeff);
                switch (this.getType()) {
                    case GUN: {
                        continue block8;
                    }
                    case MORTAR: {
                        float explosionTimer = this.getExplosionTimer();
                        double height = this.field_70170_p.func_175645_m(this.func_180425_c()).func_177956_o();
                        if (this.field_70163_u < height + 4.0 || explosionTimer < 1.0f) {
                            ParticleUtil.spawnParticleGlow(this.field_70170_p, px, py, pz, 0.025f * (this.field_70146_Z.nextFloat() - 0.5f), 0.025f * this.field_70146_Z.nextFloat(), 0.025f * (this.field_70146_Z.nextFloat() - 0.5f), particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), 6.0f, 20);
                            continue block8;
                        }
                        ParticleUtil.spawnParticleGlow(this.field_70170_p, px, py, pz, 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.1f * this.field_70146_Z.nextFloat(), 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f), particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), 2.0f, 12);
                        continue block8;
                    }
                    case PILLAR: {
                        continue block8;
                    }
                    case HOMING: {
                        ParticleUtil.spawnParticleGlow(this.field_70170_p, px, py, pz, 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f), particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), 4.0f, 12);
                        continue block8;
                    }
                    case SPLASH: {
                        ParticleUtil.spawnParticleGlow(this.field_70170_p, px, py, pz, 0.025f * (this.field_70146_Z.nextFloat() - 0.5f), -0.025f * this.field_70146_Z.nextFloat(), 0.025f * (this.field_70146_Z.nextFloat() - 0.5f), particleColor.getRed(), particleColor.getGreen(), particleColor.getBlue(), 6.0f, 40);
                        continue block8;
                    }
                    case TURRET: {
                        continue block8;
                    }
                }
            }
        }
    }

    private void handleHoming() {
        if (this.homingTarget != null) {
            Vec3d homingPosition = (Vec3d)this.homingTarget.get();
            double targetX = homingPosition.field_72450_a;
            double targetY = homingPosition.field_72448_b;
            double targetZ = homingPosition.field_72449_c;
            Vec3d targetVector = new Vec3d(targetX - this.field_70165_t, targetY - this.field_70163_u, targetZ - this.field_70161_v);
            double length = targetVector.func_72433_c();
            targetVector = targetVector.func_186678_a(this.homingVelocity / length);
            this.field_70159_w = (1.0 - this.homingRatio) * this.field_70159_w + this.homingRatio * targetVector.field_72450_a;
            this.field_70181_x = (1.0 - this.homingRatio) * this.field_70181_x + this.homingRatio * targetVector.field_72448_b;
            this.field_70179_y = (1.0 - this.homingRatio) * this.field_70179_y + this.homingRatio * targetVector.field_72449_c;
        }
    }

    private boolean canPierce(@Nonnull RayTraceResult rayTraceResult) {
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            return this.pierceBlocks;
        }
        return true;
    }

    private void onHit(RayTraceResult rayTraceResult) {
        if (this.getType() == Type.SPLASH) {
            return;
        }
        Vec3d hitPos = rayTraceResult.field_72307_f;
        PacketHandler.INSTANCE.sendToAllTracking((IMessage)new MessageEmberBurstFX(hitPos.field_72450_a, hitPos.field_72448_b, hitPos.field_72449_c), (Entity)this);
        this.func_70106_y();
    }

    public float getExplosionTimer() {
        return ((Float)this.func_184212_Q().func_187225_a(explosionTimer)).floatValue();
    }

    public void setExplosionTimer(float time) {
        this.func_184212_Q().func_187227_b(explosionTimer, (Object)Float.valueOf(time));
        this.func_184212_Q().func_187217_b(explosionTimer);
    }

    public float getPillarHeight() {
        return ((Float)this.func_184212_Q().func_187225_a(pillarHeight)).floatValue();
    }

    public void setPillarHeight(float height) {
        this.func_184212_Q().func_187227_b(pillarHeight, (Object)Float.valueOf(height));
        this.func_184212_Q().func_187217_b(pillarHeight);
    }

    public int getTick() {
        return (Integer)this.func_184212_Q().func_187225_a(tick);
    }

    public void setTick(int n) {
        this.func_184212_Q().func_187227_b(tick, (Object)n);
        this.func_184212_Q().func_187217_b(tick);
    }

    public Type getType() {
        Type[] values = Type.values();
        Integer ordinal = (Integer)this.func_184212_Q().func_187225_a(typeOrdinal);
        return values[MathHelper.func_76125_a((int)ordinal, (int)0, (int)(values.length - 1))];
    }

    public void setType(Type type) {
        this.func_184212_Q().func_187227_b(typeOrdinal, (Object)type.ordinal());
        this.func_184212_Q().func_187217_b(typeOrdinal);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(typeOrdinal, (Object)Type.GUN.ordinal());
        this.func_184212_Q().func_187214_a(explosionTimer, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(pillarHeight, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(tick, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    static enum Type {
        GUN,
        MORTAR,
        PILLAR,
        HOMING,
        SPLASH,
        TURRET_FLOAT,
        TURRET,
        TURRET_HEAL;

    }
}

