/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import teamroots.embers.compat.crafttweaker.CTUtil;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@ZenRegister
@ZenClass(value="mods.embers.Stamper")
public class Stamper {
    public static final String NAME = "Stamper";
    public static final String CLASS = "mods.embers.Stamper";

    @ZenMethod
    public static void add(IItemStack output, ILiquidStack liquid, @NotNull IIngredient stamp, @Optional IIngredient input) {
        ItemStampingRecipe recipe = new ItemStampingRecipe(CTUtil.toIngredient(input), CraftTweakerMC.getLiquidStack((ILiquidStack)liquid), CTUtil.toIngredient(stamp), CraftTweakerMC.getItemStack((IItemStack)output));
        CraftTweaker.LATE_ACTIONS.add(new Add(recipe));
    }

    @ZenMethod
    public static void remove(IItemStack output) {
        CraftTweaker.LATE_ACTIONS.add(new RemoveByOutput(CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweaker.LATE_ACTIONS.add(new RemoveAll());
    }

    private static List<ItemStampingRecipe> getRecipesByOutput(ItemStack stack) {
        return RecipeRegistry.stampingRecipes.stream().filter(recipe -> ItemStack.func_77989_b((ItemStack)stack, (ItemStack)recipe.result)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static class RemoveAll
    implements IAction {
        protected RemoveAll() {
        }

        public void apply() {
            RecipeRegistry.stampingRecipes.clear();
        }

        public String describe() {
            return String.format("Removing all %s recipes", Stamper.NAME);
        }
    }

    public static class RemoveByOutput
    implements IAction {
        ItemStack output;

        protected RemoveByOutput(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            RecipeRegistry.stampingRecipes.removeAll(Stamper.getRecipesByOutput(this.output));
        }

        public String describe() {
            return String.format("Removing %s recipes with output: %s", Stamper.NAME, this.output.toString());
        }
    }

    public static class Add
    implements IAction {
        ItemStampingRecipe recipe;

        public Add(ItemStampingRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            RecipeRegistry.stampingRecipes.add(this.recipe);
        }

        public String describe() {
            return String.format("Adding %s recipe: %s", Stamper.NAME, this.recipe.toString());
        }
    }
}

