/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.api.projectile;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import teamroots.embers.api.projectile.IProjectileEffect;
import teamroots.embers.api.projectile.IProjectilePreset;

public class EffectArea
implements IProjectileEffect {
    IProjectileEffect effect;
    double radius;
    boolean activateOnFizzle;

    public EffectArea(IProjectileEffect effect, double radius, boolean activateOnFizzle) {
        this.effect = effect;
        this.radius = radius;
        this.activateOnFizzle = activateOnFizzle;
    }

    public IProjectileEffect getEffect() {
        return this.effect;
    }

    public void setEffect(IProjectileEffect effect) {
        this.effect = effect;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public boolean doesActivateOnFizzle() {
        return this.activateOnFizzle;
    }

    public void setActivateOnFizzle(boolean activateOnFizzle) {
        this.activateOnFizzle = activateOnFizzle;
    }

    @Override
    public void onHit(World world, RayTraceResult raytrace, IProjectilePreset projectile) {
        Vec3d pos = raytrace.field_72307_f;
        this.doAreaEffect(world, projectile, pos);
    }

    @Override
    public void onFizzle(World world, Vec3d pos, @Nullable IProjectilePreset projectile) {
        if (this.activateOnFizzle) {
            this.doAreaEffect(world, projectile, pos);
        }
    }

    private void doAreaEffect(World world, IProjectilePreset projectile, Vec3d pos) {
        AxisAlignedBB aabb = new AxisAlignedBB(pos.field_72450_a - this.radius, pos.field_72448_b - this.radius, pos.field_72449_c - this.radius, pos.field_72450_a + this.radius, pos.field_72448_b + this.radius, pos.field_72449_c + this.radius);
        List entities = world.func_175674_a(projectile.getShooter(), aabb, entity -> true);
        for (Entity entity2 : entities) {
            this.effect.onHit(world, new RayTraceResult(entity2), projectile);
        }
    }
}

