/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.symbol;

import info.openmods.calc.Frame;
import info.openmods.calc.FrameFactory;
import info.openmods.calc.executable.IExecutable;
import info.openmods.calc.symbol.FixedCallable;
import info.openmods.calc.utils.Stack;

public class CompiledFunction<E>
extends FixedCallable<E> {
    private final IExecutable<E> body;
    private final Frame<E> scope;

    public CompiledFunction(int argCount, int resultCount, IExecutable<E> body, Frame<E> scope) {
        super(argCount, resultCount);
        this.body = body;
        this.scope = scope;
    }

    @Override
    public void call(Frame<E> frame) {
        Frame<E> newFrame = FrameFactory.newLocalFrameWithSubstack(this.scope, this.argCount);
        Stack<E> resultStack = newFrame.stack();
        for (int i = 0; i < this.argCount; ++i) {
            E arg = resultStack.pop();
            newFrame.symbols().put("_" + (i + 1), arg);
        }
        this.body.execute(newFrame);
        resultStack.checkSizeIsExactly(this.resultCount);
    }
}

