/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.guilib.core;

import com.mcf.davidee.guilib.core.Container;
import com.mcf.davidee.guilib.core.Widget;
import org.lwjgl.input.Mouse;

public abstract class Scrollbar
extends Widget {
    protected int yClick = -1;
    protected Container container;
    private int topY;
    private int bottomY;
    private int offset;

    public Scrollbar(int width) {
        super(width, 0);
    }

    protected abstract void shiftChildren(int var1);

    protected abstract void drawBoundary(int var1, int var2, int var3, int var4);

    protected abstract void drawScrollbar(int var1, int var2, int var3, int var4);

    public void revalidate(int topY, int bottomY) {
        this.topY = topY;
        this.bottomY = bottomY;
        this.height = bottomY - topY;
        int heightDiff = this.getHeightDifference();
        if (this.offset != 0 && heightDiff <= 0) {
            this.offset = 0;
        }
        if (heightDiff > 0 && this.offset < -heightDiff) {
            this.offset = -heightDiff;
        }
        if (this.offset != 0) {
            this.shiftChildren(this.offset);
        }
    }

    public void onChildRemoved() {
        int heightDiff = this.getHeightDifference();
        if (this.offset != 0) {
            if (heightDiff <= 0) {
                this.shiftChildren(-this.offset);
                this.offset = 0;
            } else if (this.offset < -heightDiff) {
                this.shiftChildren(-heightDiff - this.offset);
                this.offset = -heightDiff;
            }
        }
    }

    public void setContainer(Container c) {
        this.container = c;
    }

    protected int getHeightDifference() {
        return this.container.getContentHeight() - (this.bottomY - this.topY);
    }

    protected int getLength() {
        if (this.container.getContentHeight() == 0) {
            return 0;
        }
        int length = (this.bottomY - this.topY) * (this.bottomY - this.topY) / this.container.getContentHeight();
        if (length < 32) {
            length = 32;
        }
        if (length > this.bottomY - this.topY - 8) {
            length = this.bottomY - this.topY - 8;
        }
        return length;
    }

    @Override
    public void draw(int mx, int my) {
        int length = this.getLength();
        if (Mouse.isButtonDown((int)0)) {
            if (this.yClick == -1) {
                if (this.inBounds(mx, my)) {
                    this.yClick = my;
                }
            } else {
                float scrollMultiplier = 1.0f;
                int diff = this.getHeightDifference();
                if (diff < 1) {
                    diff = 1;
                }
                this.shift((int)((float)(this.yClick - my) * (scrollMultiplier /= (float)(this.bottomY - this.topY - length) / (float)diff)));
                this.yClick = my;
            }
        } else {
            this.yClick = -1;
        }
        this.drawBoundary(this.x, this.topY, this.width, this.height);
        int y = -this.offset * (this.bottomY - this.topY - length) / this.getHeightDifference() + this.topY;
        if (y < this.topY) {
            y = this.topY;
        }
        this.drawScrollbar(this.x, y, this.width, length);
    }

    @Override
    public boolean click(int mx, int my) {
        return false;
    }

    @Override
    public boolean shouldRender(int topY, int bottomY) {
        return this.getHeightDifference() > 0;
    }

    public void shiftRelative(int i) {
        int heightDiff = this.getHeightDifference();
        if (heightDiff > 0) {
            int result;
            int dif = this.offset + (i = (int)((float)i * (1.0f + (float)heightDiff / (float)(this.bottomY - this.topY))));
            if (dif > 0) {
                dif = 0;
            }
            if (dif < -heightDiff) {
                dif = -heightDiff;
            }
            if ((result = dif - this.offset) != 0) {
                this.shiftChildren(result);
            }
            this.offset = dif;
        }
    }

    public void shift(int i) {
        int heightDiff = this.getHeightDifference();
        if (heightDiff > 0) {
            int result;
            int dif = this.offset + i;
            if (dif > 0) {
                dif = 0;
            }
            if (dif < -heightDiff) {
                dif = -heightDiff;
            }
            if ((result = dif - this.offset) != 0) {
                this.shiftChildren(result);
            }
            this.offset = dif;
        }
    }

    public static interface Shiftable {
        public void shiftY(int var1);
    }
}

