/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.crafter.CrafterBaseTE;
import mcjty.rftools.craftinggrid.CraftingRecipe;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketCrafter
implements IMessage {
    private BlockPos pos;
    private int recipeIndex;
    private ItemStack[] items;
    private boolean keepOne;
    private CraftingRecipe.CraftMode craftInternal;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.keepOne = buf.readBoolean();
        this.craftInternal = CraftingRecipe.CraftMode.values()[buf.readByte()];
        this.recipeIndex = buf.readByte();
        int l = buf.readByte();
        if (l == 0) {
            this.items = null;
        } else {
            this.items = new ItemStack[l];
            for (int i = 0; i < l; ++i) {
                boolean b = buf.readBoolean();
                this.items[i] = b ? NetworkTools.readItemStack((ByteBuf)buf) : ItemStack.field_190927_a;
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeBoolean(this.keepOne);
        buf.writeByte(this.craftInternal.ordinal());
        buf.writeByte(this.recipeIndex);
        if (this.items != null) {
            buf.writeByte(this.items.length);
            for (ItemStack item : this.items) {
                if (item.func_190926_b()) {
                    buf.writeBoolean(false);
                    continue;
                }
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)item);
            }
        } else {
            buf.writeByte(0);
        }
    }

    public PacketCrafter() {
    }

    public PacketCrafter(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketCrafter(BlockPos pos, int recipeIndex, InventoryCrafting inv, ItemStack result, boolean keepOne, CraftingRecipe.CraftMode craftInternal) {
        this.pos = pos;
        this.recipeIndex = recipeIndex;
        this.items = new ItemStack[10];
        if (inv != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack slot = inv.func_70301_a(i);
                this.items[i] = !slot.func_190926_b() ? slot.func_77946_l() : ItemStack.field_190927_a;
            }
        } else {
            for (int i = 0; i < 9; ++i) {
                this.items[i] = ItemStack.field_190927_a;
            }
        }
        this.items[9] = result.func_190926_b() ? ItemStack.field_190927_a : result.func_77946_l();
        this.keepOne = keepOne;
        this.craftInternal = craftInternal;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().func_130014_f_().func_175625_s(this.pos);
            if (!(te instanceof CrafterBaseTE)) {
                Logging.logError((String)"Wrong type of tile entity (expected CrafterBaseTE)!");
                return;
            }
            CrafterBaseTE crafterBlockTileEntity = (CrafterBaseTE)te;
            crafterBlockTileEntity.noRecipesWork = false;
            if (this.recipeIndex != -1) {
                this.updateRecipe(crafterBlockTileEntity);
            }
        });
        ctx.setPacketHandled(true);
    }

    private void updateRecipe(CrafterBaseTE crafterBlockTileEntity) {
        CraftingRecipe recipe = crafterBlockTileEntity.getRecipe(this.recipeIndex);
        recipe.setRecipe(this.items, this.items[9]);
        recipe.setKeepOne(this.keepOne);
        recipe.setCraftMode(this.craftInternal);
        crafterBlockTileEntity.selectRecipe(this.recipeIndex);
        crafterBlockTileEntity.markDirtyClient();
    }
}

