/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartModel;
import appeng.capabilities.Capabilities;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.IEnergyStorage;

public class PartP2PFEPower
extends PartP2PTunnel<PartP2PFEPower> {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_fe");
    private static final IEnergyStorage NULL_ENERGY_STORAGE = new NullEnergyStorage();
    private final IEnergyStorage inputHandler = new InputEnergyStorage();
    private final IEnergyStorage outputHandler = new OutputEnergyStorage();

    public PartP2PFEPower(ItemStack is) {
        super(is);
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    public void onTunnelNetworkChange() {
        this.getHost().notifyNeighbors();
    }

    private IEnergyStorage getAttachedEnergyStorage() {
        TileEntity self;
        TileEntity te;
        if (this.isActive() && (te = (self = this.getTile()).func_145831_w().func_175625_s(self.func_174877_v().func_177972_a(this.getSide().getFacing()))) != null && te.hasCapability(Capabilities.FORGE_ENERGY, this.getSide().getOpposite().getFacing())) {
            return (IEnergyStorage)te.getCapability(Capabilities.FORGE_ENERGY, this.getSide().getOpposite().getFacing());
        }
        return NULL_ENERGY_STORAGE;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability) {
        if (capability == Capabilities.FORGE_ENERGY) {
            return true;
        }
        return super.hasCapability(capability);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability) {
        if (capability == Capabilities.FORGE_ENERGY) {
            if (this.isOutput()) {
                return (T)this.outputHandler;
            }
            return (T)this.inputHandler;
        }
        return super.getCapability(capability);
    }

    private static class NullEnergyStorage
    implements IEnergyStorage {
        private NullEnergyStorage() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return 0;
        }

        public int getMaxEnergyStored() {
            return 0;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return false;
        }
    }

    private class OutputEnergyStorage
    implements IEnergyStorage {
        private OutputEnergyStorage() {
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int total = PartP2PFEPower.this.getAttachedEnergyStorage().extractEnergy(maxExtract, simulate);
            if (!simulate) {
                PartP2PFEPower.this.queueTunnelDrain(PowerUnits.RF, total);
            }
            return total;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public boolean canExtract() {
            return PartP2PFEPower.this.getAttachedEnergyStorage().canExtract();
        }

        public boolean canReceive() {
            return false;
        }

        public int getMaxEnergyStored() {
            return PartP2PFEPower.this.getAttachedEnergyStorage().getMaxEnergyStored();
        }

        public int getEnergyStored() {
            return PartP2PFEPower.this.getAttachedEnergyStorage().getEnergyStored();
        }
    }

    private class InputEnergyStorage
    implements IEnergyStorage {
        private InputEnergyStorage() {
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int total = 0;
            try {
                int outputTunnels = PartP2PFEPower.this.getOutputs().size();
                if (outputTunnels == 0 | maxReceive == 0) {
                    return 0;
                }
                int amountPerOutput = maxReceive / outputTunnels;
                int overflow = amountPerOutput == 0 ? maxReceive : maxReceive % amountPerOutput;
                for (PartP2PFEPower target : PartP2PFEPower.this.getOutputs()) {
                    IEnergyStorage output = target.getAttachedEnergyStorage();
                    int toSend = amountPerOutput + overflow;
                    int received = output.receiveEnergy(toSend, simulate);
                    overflow = toSend - received;
                    total += received;
                }
                if (!simulate) {
                    PartP2PFEPower.this.queueTunnelDrain(PowerUnits.RF, total);
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            return total;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            int total = 0;
            try {
                for (PartP2PFEPower t : PartP2PFEPower.this.getOutputs()) {
                    total += t.getAttachedEnergyStorage().getMaxEnergyStored();
                }
            }
            catch (GridAccessException e) {
                return 0;
            }
            return total;
        }

        public int getEnergyStored() {
            int total = 0;
            try {
                for (PartP2PFEPower t : PartP2PFEPower.this.getOutputs()) {
                    total += t.getAttachedEnergyStorage().getEnergyStored();
                }
            }
            catch (GridAccessException e) {
                return 0;
            }
            return total;
        }
    }
}

