/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.util;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.render.util.HalfBakedQuad;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class TankRenderHelper {
    private static final Double px = 0.0625;

    public static HalfBakedQuad.HalfBakedList mkTank(SmartTank tank, double xzBorder, double miny, double maxy, boolean renderBottom) {
        if (tank != null) {
            float ratio = tank.getFilledRatio();
            FluidStack fluid = tank.getFluid();
            if (fluid != null && ratio > 0.0f) {
                boolean gas;
                TextureAtlasSprite sprite;
                float height = 1.0f - ratio;
                ResourceLocation still = fluid.getFluid().getStill(fluid);
                int color = fluid.getFluid().getColor(fluid);
                Vector4f vecC = new Vector4f((double)(color >> 16 & 0xFF) / 255.0, (double)(color >> 8 & 0xFF) / 255.0, (double)(color & 0xFF) / 255.0, 1.0);
                TextureAtlasSprite textureAtlasSprite = sprite = still == null ? null : Minecraft.func_71410_x().func_147117_R().getTextureExtry(still.toString());
                if (sprite == null) {
                    sprite = Minecraft.func_71410_x().func_147117_R().func_174944_f();
                    vecC = null;
                }
                BoundingBox bb = (gas = fluid.getFluid().isGaseous(fluid)) ? new BoundingBox(xzBorder * px, (maxy - (maxy - miny) * (double)ratio) * px, xzBorder * px, (16.0 - xzBorder) * px, maxy * px, (16.0 - xzBorder) * px) : new BoundingBox(xzBorder * px, miny * px, xzBorder * px, (16.0 - xzBorder) * px, ((maxy - miny) * (double)ratio + miny) * px, (16.0 - xzBorder) * px);
                HalfBakedQuad.HalfBakedList buffer = new HalfBakedQuad.HalfBakedList();
                buffer.add(bb, EnumFacing.NORTH, 0.0f, 1.0f, height, 1.0f, sprite, vecC, gas);
                buffer.add(bb, EnumFacing.EAST, 0.0f, 1.0f, height, 1.0f, sprite, vecC, gas);
                buffer.add(bb, EnumFacing.SOUTH, 0.0f, 1.0f, height, 1.0f, sprite, vecC, gas);
                buffer.add(bb, EnumFacing.WEST, 0.0f, 1.0f, height, 1.0f, sprite, vecC, gas);
                if (!gas && height > 0.0f || renderBottom) {
                    buffer.add(bb, EnumFacing.UP, 0.0f, 1.0f, 0.0f, 1.0f, sprite, vecC);
                }
                if (gas && height > 0.0f || renderBottom) {
                    buffer.add(bb, EnumFacing.DOWN, 0.0f, 1.0f, 0.0f, 1.0f, sprite, vecC);
                }
                return buffer;
            }
        }
        return null;
    }
}

