/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.entity;

import com.google.common.base.Optional;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.machine.base.block.AbstractMachineBlock;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.machine.entity.RenderFallingMachine;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderio")
public class EntityFallingMachine
extends EntityFallingBlock {
    @Nonnull
    private static final DataParameter<Optional<IBlockState>> REAL_BLOCK = EntityDataManager.func_187226_a(EntityFallingMachine.class, (DataSerializer)DataSerializers.field_187197_g);
    protected IBlockState renderBS = null;
    @Nonnull
    protected ItemStack dropStack = Prep.getEmpty();

    @SubscribeEvent
    public static void onEntityRegister(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("enderio", "falling_machine"), EntityFallingMachine.class, (String)"enderio.falling_machine", (int)1, (Object)"enderio", (int)64, (int)100, (boolean)true);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityFallingMachine.class, (IRenderFactory)RenderFallingMachine.FACTORY);
    }

    public EntityFallingMachine(World worldIn) {
        super(worldIn, 0.0, 0.0, 0.0, Blocks.field_192438_dM.func_176223_P());
    }

    public <T extends AbstractMachineEntity> EntityFallingMachine(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AbstractMachineBlock<T> block) {
        super(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
        ItemStack nbtDrop;
        AbstractMachineEntity te = (AbstractMachineEntity)AbstractMachineBlock.getAnyTileEntity((IBlockAccess)worldIn, (BlockPos)pos, (Class)block.getTeClass());
        if (te != null) {
            this.field_145810_d = te.func_189515_b(new NBTTagCompound());
        }
        if ((nbtDrop = block.getNBTDrop((IBlockAccess)worldIn, pos, worldIn.func_180495_p(pos), 0, te)) != null) {
            this.dropStack = nbtDrop;
        }
        this.func_145806_a(true);
        this.setRealBlockState(super.func_175131_l());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(REAL_BLOCK, (Object)Optional.absent());
    }

    public void func_70071_h_() {
        IBlockState blockState;
        if (this.field_70170_p.field_72995_K && this.renderBS == null && (blockState = this.field_70170_p.func_180495_p(this.func_184531_j())).func_177230_c() instanceof AbstractMachineBlock) {
            this.renderBS = blockState.func_177230_c().getExtendedState(blockState.func_177230_c().func_176221_a(this.field_70170_p.func_180495_p(this.func_184531_j()), (IBlockAccess)this.field_70170_p, this.func_184531_j()), (IBlockAccess)this.field_70170_p, this.func_184531_j());
        }
        if (super.func_175131_l() != null) {
            super.func_70071_h_();
        }
    }

    @Nullable
    public EntityItem func_70099_a(@Nonnull ItemStack stack, float offsetY) {
        if (Prep.isValid(this.dropStack)) {
            return super.func_70099_a(this.dropStack, offsetY);
        }
        return super.func_70099_a(stack, offsetY);
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound tag = new NBTTagCompound();
        this.dropStack.func_77955_b(tag);
        compound.func_74782_a("dropStack", (NBTBase)tag);
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRealBlockState(super.func_175131_l());
        this.dropStack = new ItemStack(compound.func_74775_l("dropStack"));
    }

    @Nullable
    public IBlockState func_175131_l() {
        if (this.renderBS != null) {
            return this.renderBS;
        }
        IBlockState realBlockState = this.getRealBlockState();
        if (realBlockState != null) {
            return realBlockState;
        }
        return super.func_175131_l();
    }

    public void setRealBlockState(@Nullable IBlockState state) {
        this.field_70180_af.func_187227_b(REAL_BLOCK, (Object)Optional.fromNullable((Object)state));
    }

    @Nullable
    public IBlockState getRealBlockState() {
        return (IBlockState)((Optional)this.field_70180_af.func_187225_a(REAL_BLOCK)).orNull();
    }
}

