/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capability;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public final class ItemTools {
    @CapabilityInject(value=IItemHandler.class)
    public static final Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;
    @Nonnull
    public static final Limit NO_LIMIT = new Limit(Integer.MAX_VALUE, Integer.MAX_VALUE){

        @Override
        public void useItems(int count) {
        }
    };

    private ItemTools() {
    }

    public static boolean doPush(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        CallbackPush callback = new CallbackPush(world, pos);
        NNList.FACING.apply((NNList.ShortCallback)callback);
        return callback.movedSomething;
    }

    public static boolean doPull(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        CallbackPull callback = new CallbackPull(world, pos);
        NNList.FACING.apply((NNList.ShortCallback)callback);
        return callback.movedSomething;
    }

    public static MoveResult move(@Nonnull Limit limit, @Nonnull IBlockAccess world, @Nonnull BlockPos sourcePos, @Nonnull EnumFacing sourceFacing, @Nonnull BlockPos targetPos, @Nonnull EnumFacing targetFacing) {
        return ItemTools.move(limit, world, null, sourcePos, sourceFacing, null, targetPos, targetFacing);
    }

    public static MoveResult move(@Nonnull Limit limit, @Nonnull IBlockAccess world, @Nonnull TileEntity sourceTE, @Nonnull EnumFacing sourceFacing, @Nonnull BlockPos targetPos, @Nonnull EnumFacing targetFacing) {
        return ItemTools.move(limit, world, sourceTE, sourceTE.func_174877_v(), sourceFacing, null, targetPos, targetFacing);
    }

    public static MoveResult move(@Nonnull Limit limit, @Nonnull IBlockAccess world, @Nonnull BlockPos sourcePos, @Nonnull EnumFacing sourceFacing, @Nonnull TileEntity targetTE, @Nonnull EnumFacing targetFacing) {
        return ItemTools.move(limit, world, null, sourcePos, sourceFacing, targetTE, targetTE.func_174877_v(), targetFacing);
    }

    public static MoveResult move(@Nonnull Limit limit, @Nonnull IBlockAccess world, @Nonnull TileEntity sourceTE, @Nonnull EnumFacing sourceFacing, @Nonnull TileEntity targetTE, @Nonnull EnumFacing targetFacing) {
        return ItemTools.move(limit, world, sourceTE, sourceTE.func_174877_v(), sourceFacing, targetTE, targetTE.func_174877_v(), targetFacing);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static MoveResult move(@Nonnull Limit limit, @Nonnull IBlockAccess world, @Nullable TileEntity sourceTE, @Nonnull BlockPos sourcePos, @Nonnull EnumFacing sourceFacing, @Nullable TileEntity targetTE, @Nonnull BlockPos targetPos, @Nonnull EnumFacing targetFacing) {
        MoveResult moveResult;
        IItemHandler targetHandler;
        IItemHandler sourceHandler;
        TileEntity source;
        boolean movedSomething;
        Profiler profiler;
        block8: {
            TileEntity target;
            if (!limit.canWork()) {
                return MoveResult.LIMITED;
            }
            profiler = world instanceof World ? ((World)world).field_72984_F : null;
            movedSomething = false;
            source = sourceTE != null ? sourceTE : world.func_175625_s(sourcePos);
            if (source == null) return MoveResult.SOURCE_EMPTY;
            if (!source.func_145830_o()) return MoveResult.SOURCE_EMPTY;
            if (source.func_145831_w().field_72995_K) return MoveResult.SOURCE_EMPTY;
            if (!ItemTools.canPullFrom(source, sourceFacing)) return MoveResult.SOURCE_EMPTY;
            Prof.start(profiler, "from_", (Object)source);
            TileEntity tileEntity = target = targetTE != null ? targetTE : world.func_175625_s(targetPos);
            if (target != null && target.func_145830_o() && ItemTools.canPutInto(target, targetFacing)) {
                Prof.start(profiler, "to_", (Object)target);
                sourceHandler = ItemTools.getExternalInventory(source, sourceFacing);
                if (sourceHandler != null && ItemTools.hasItems(sourceHandler)) {
                    targetHandler = ItemTools.getExternalInventory(target, targetFacing);
                    if (targetHandler != null && ItemTools.hasFreeSpace(targetHandler)) {
                        break block8;
                    } else {
                        Prof.stop(profiler, 2);
                        return MoveResult.TARGET_FULL;
                    }
                }
                Prof.stop(profiler, 2);
                return MoveResult.SOURCE_EMPTY;
            }
            Prof.stop(profiler);
            return MoveResult.TARGET_FULL;
        }
        for (int i = 0; i < sourceHandler.getSlots(); ++i) {
            ItemStack sourceRejected;
            ItemStack targetRejected;
            ItemStack removable = sourceHandler.extractItem(i, limit.getItems(), true);
            if (!Prep.isValid(removable)) continue;
            ItemStack unacceptable = ItemTools.insertItemStacked(targetHandler, removable, true);
            int movable = removable.func_190916_E() - unacceptable.func_190916_E();
            if (movable <= 0) continue;
            ItemStack removed = sourceHandler.extractItem(i, movable, false);
            if (Prep.isValid(removed) && Prep.isValid(targetRejected = ItemTools.insertItemStacked(targetHandler, removed, false)) && Prep.isValid(sourceRejected = ItemTools.insertItemStacked(sourceHandler, targetRejected, false))) {
                EntityItem drop = new EntityItem(source.func_145831_w(), (double)sourcePos.func_177958_n() + 0.5, (double)sourcePos.func_177956_o() + 0.5, (double)sourcePos.func_177952_p() + 0.5, sourceRejected);
                source.func_145831_w().func_72838_d((Entity)drop);
                Prof.stop(profiler, 2);
                return MoveResult.MOVED;
            }
            movedSomething = true;
            limit.useItems(movable);
            if (limit.canWork()) continue;
            Prof.stop(profiler, 2);
            return MoveResult.MOVED;
        }
        Prof.stop(profiler);
        Prof.stop(profiler);
        if (!movedSomething) {
            moveResult = MoveResult.NO_ACTION;
            return moveResult;
        }
        moveResult = MoveResult.MOVED;
        return moveResult;
    }

    public static int doInsertItem(@Nullable IItemHandler inventory, @Nonnull ItemStack item) {
        if (inventory == null || Prep.isInvalid(item)) {
            return 0;
        }
        int startSize = item.func_190916_E();
        ItemStack res = ItemTools.insertItemStacked(inventory, item.func_77946_l(), false);
        int val = startSize - res.func_190916_E();
        return val;
    }

    public static boolean hasFreeSpace(@Nonnull IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!Prep.isInvalid(stack) && (!stack.func_77985_e() || stack.func_190916_E() >= stack.func_77976_d() || stack.func_190916_E() >= handler.getSlotLimit(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItems(@Nonnull IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!Prep.isValid(stack)) continue;
            return true;
        }
        return false;
    }

    public static int countItems(@Nonnull IItemHandler handler, @Nonnull ItemStack template) {
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!ItemTools.areStacksEqualIgnoringDamage(template, stack)) continue;
            count += stack.func_190916_E();
        }
        return count;
    }

    public static int getInsertLimit(@Nonnull IItemHandler handler, @Nonnull ItemStack template, int limit) {
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!ItemTools.areStacksEqualIgnoringDamage(template, stack) || (count += stack.func_190916_E()) < limit) continue;
            return 0;
        }
        return limit - count;
    }

    public static boolean areStacksEqualIgnoringDamage(@Nonnull ItemStack s1, @Nonnull ItemStack s2) {
        if (s1.func_190926_b() || s2.func_190926_b()) {
            return false;
        }
        if (!s1.func_185136_b(s2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2);
    }

    public static boolean hasAtLeast(@Nonnull IItemHandler handler, @Nonnull ItemStack template, int limit) {
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!ItemTools.areStacksEqualIgnoringDamage(template, stack) || (count += stack.func_190916_E()) < limit) continue;
            return true;
        }
        return false;
    }

    public static boolean canPutInto(@Nullable TileEntity tileEntity, @Nonnull EnumFacing facing) {
        if (tileEntity instanceof AbstractMachineEntity) {
            IoMode ioMode = ((AbstractMachineEntity)tileEntity).getIoMode(facing);
            return ioMode != IoMode.DISABLED && ioMode != IoMode.PUSH;
        }
        return true;
    }

    public static boolean canPullFrom(@Nullable TileEntity tileEntity, @Nonnull EnumFacing facing) {
        if (tileEntity instanceof AbstractMachineEntity) {
            IoMode ioMode = ((AbstractMachineEntity)tileEntity).getIoMode(facing);
            return ioMode != IoMode.DISABLED && ioMode != IoMode.PULL;
        }
        return true;
    }

    @Nullable
    public static IItemHandler getExternalInventory(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            return ItemTools.getExternalInventory(te, face);
        }
        return null;
    }

    @Nullable
    public static IItemHandler getExternalInventory(@Nonnull TileEntity tile, @Nonnull EnumFacing face) {
        return (IItemHandler)tile.getCapability((Capability)NullHelper.notnullF(ITEM_HANDLER_CAPABILITY, (String)"Capability<IItemHandler> is missing"), face);
    }

    @Nonnull
    public static ItemStack insertItemStacked(@Nonnull IItemHandler inventory, @Nonnull ItemStack stack, boolean simulate) {
        if (Prep.isValid(stack)) {
            int i;
            if (!stack.func_77985_e()) {
                return ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)stack, (boolean)simulate);
            }
            int sizeInventory = inventory.getSlots();
            int firstEmptyStack = -1;
            int origSize = stack.func_190916_E();
            for (i = 0; i < sizeInventory; ++i) {
                ItemStack slot = inventory.getStackInSlot(i);
                if (ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)slot, (ItemStack)stack)) {
                    stack = inventory.insertItem(i, stack, simulate);
                    if ((!simulate || stack.func_190916_E() == origSize) && !Prep.isInvalid(stack)) continue;
                    return stack;
                }
                if (firstEmptyStack >= 0 || !Prep.isInvalid(slot)) continue;
                firstEmptyStack = i;
            }
            if (Prep.isValid(stack) && firstEmptyStack >= 0) {
                stack = inventory.insertItem(firstEmptyStack, stack, simulate);
                if ((!simulate || stack.func_190916_E() == origSize) && Prep.isValid(stack)) {
                    for (i = 0; i < sizeInventory; ++i) {
                        stack = inventory.insertItem(i, stack, simulate);
                        if ((!simulate || stack.func_190916_E() == origSize) && !Prep.isInvalid(stack)) continue;
                        return stack;
                    }
                }
            }
        }
        return stack;
    }

    public static class Limit {
        private int stacks;
        private int items;

        public Limit(int stacks, int items) {
            this.stacks = stacks;
            this.items = items;
        }

        public Limit(int items) {
            this.stacks = Integer.MAX_VALUE;
            this.items = items;
        }

        public int getStacks() {
            return this.stacks;
        }

        public int getItems() {
            return this.items;
        }

        public void useItems(int count) {
            --this.stacks;
            this.items -= count;
        }

        public boolean canWork() {
            return this.stacks > 0 && this.items > 0;
        }

        @Nonnull
        public Limit copy() {
            return new Limit(this.stacks, this.items);
        }
    }

    public static enum MoveResult {
        NO_ACTION,
        LIMITED,
        MOVED,
        TARGET_FULL,
        SOURCE_EMPTY;

    }

    private static final class CallbackPull
    implements NNList.ShortCallback<EnumFacing> {
        @Nonnull
        private final IBlockAccess world;
        @Nonnull
        private final BlockPos pos;
        boolean movedSomething = false;

        private CallbackPull(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            this.world = world;
            this.pos = pos;
        }

        public boolean apply(@Nonnull EnumFacing facing) {
            MoveResult moveResult = ItemTools.move(NO_LIMIT, this.world, this.pos.func_177972_a(facing), facing.func_176734_d(), this.pos, facing);
            if (moveResult == MoveResult.TARGET_FULL) {
                return true;
            }
            this.movedSomething |= moveResult == MoveResult.MOVED;
            return false;
        }
    }

    private static final class CallbackPush
    implements NNList.ShortCallback<EnumFacing> {
        @Nonnull
        private final IBlockAccess world;
        @Nonnull
        private final BlockPos pos;
        boolean movedSomething = false;

        private CallbackPush(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
            this.world = world;
            this.pos = pos;
        }

        public boolean apply(@Nonnull EnumFacing facing) {
            MoveResult moveResult = ItemTools.move(NO_LIMIT, this.world, this.pos, facing, this.pos.func_177972_a(facing), facing.func_176734_d());
            if (moveResult == MoveResult.SOURCE_EMPTY) {
                return true;
            }
            this.movedSomething |= moveResult == MoveResult.MOVED;
            return false;
        }
    }
}

